function [XN, MeX, StX]=MeStdNorm(X,MeX,StX)
%Mean and Std Normalization

%fprintf('Normalizing...');



%Default inputs
if nargin<2
    MeX=mean(X,2);     
    StX=std(X,[],2);       
end



%Prepare output data with desired precission
[ss, sn]=size(X); %sample size and sample number

    
%Check Data
i=StX<=0;
if sum(i(:))>0
    error('Some values of standard deviation StX are <= 0\n');    
end

%Normalize
XN=(X-repmat(MeX,[1,sn]))./repmat(StX,[1,sn]);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%December 1, 2015
% %Default inputs
% if nargin<4
%     Precision='double';
% end
% if nargin<2
%     MeX = mean(X,2);     
%     StX = std(X,0,2);   
% end
% 
% 
% 
% %Prepare output data with desired precission
% [ss, sn]=size(X); %sample size and sample number
% if strcmp(Precision,'single')
%     XN=single(zeros(ss,sn));
% else
%     XN=(zeros(ss,sn));
% end
%     
% %Check Data
% i=StX==0;
% if sum(i)>0
%     warning('Some values of standard deviation StX replaced by 1 cause they are 0\n');
%     StX(i)=1;
% end
% 
% %Normalize
% for s=1:sn       
%     XN(:,s)=(X(:,s)-MeX)./StX;
% end


