function GmmTr(modelFile,XTr,YTr,XDev,YDev,SpnBinDir,NG,P)
% Gmm Training
%YTr: must be a vector of 0s

%Number of Gaussians
%[StW,StM,StS]=Kald2MatGmm(StKaldGmm); [FL,NG]=size(StM);


%Add Tr samples if less than FL
[FL,TrNf]=size(XTr);
if FL>TrNf    
    Need=FL-TrNf+1;   
    p=round(TrNf*rand(1,Need)); p=max(min(p,TrNf),1);   
    XTr=[XTr XTr(:,p)];
    YTr=[YTr YTr(:,p)];    
    warning('Added Tr samples becasue less than FL');
end

   
%
[FL,TrNf]=size(XTr);
[FL,DevNf]=size(XDev);
fprintf('Tr and Dev: %d and %d samples\n',TrNf,DevNf);

[GmmObj]=FitGaus(XTr',XDev',NG,-1,P.ExOpt.numIterPD);

%
[W,M,S]=MatObj2JuGmm(GmmObj); %S is Std
KaldGmm=Mat2KaldGmm(W,M,S);
Spn=Gmm2Spn1(KaldGmm);


%Mod
Ju2RoSpn(modelFile,Spn);


%
PrintSpnLosF(XTr,YTr,XDev,YDev,modelFile,'Gmm');


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [FGmmObj]=FitGaus(XTr,XDev,MaxNG,StGmmObj,Replicates)
%XTr and XDev: matlab format (each row data, each column variable) 

% S.mu = StGmmObj.mu;
% S.Sigma = StGmmObj.Sigma;
% S.PComponents = StGmmObj.PComponents;
%FGmmObj = gmdistribution.fit(XTr,MaxNG,'CovType','diagonal','Start',S);
FGmmObj = gmdistribution.fit(XTr,MaxNG,'CovType','diagonal','Replicates',Replicates);



% %
% i=1;
% ng=1;
% LPTr=log(zeros(1,MaxNG));
% LPDev=log(zeros(1,MaxNG));
% while ng <= MaxNG
%     fprintf('NG: %d\n',ng);
%     GMM{i} = gmdistribution.fit(XTr,ng,'CovType','diagonal','Replicates',10); 
%     LPTr(i) = mean(log(pdf(GMM{i},XTr)));
%     LPDev(i) = mean(log(pdf(GMM{i},XDev)));         
%     i=i+1;
%     ng=ng+1;    
% end
% %Chose max
% [v,p]=max(LPDev);
% FGmmObj=GMM{p};
% fprintf('Max-Lik in Dev with NG: %d\n',p);






















