function [ptr,pdev,pdev_tr]=SampDistrTrDevSet(AvTr,AsTr,AvDev,AsDev,kind,AvTrY,AvDevY)
%Sample Distribution of a Tr-Dev Set of samples 
%REMEMBER NOTATION: a Tr set of samples is made of instances (X) and labels (Y)
%
% Never take Dev Samples for Tr. Viceversa may possible
% AvTr=105; AvDev=5;
% AsTr=100; AsDev=AsTr*0.2;
%

TAv=AvTr+AvDev;
F=1-AsDev/AsTr; %Factor 0.8


%
AsTr2=min([AsTr AvTr floor(TAv/(2-F))]); %better floor, round can make AvTr > AsTr2+miss
AsDev2=round(AsTr2*(1-F)); 
miss=max(AsDev2-AvDev,0);
%
p=jrandperm(AvTr,AsTr2+miss,kind);
ptr=p(1:AsTr2);
pdev_tr=p(AsTr2+1:end); 
pdev=jrandperm(AvDev,AsDev2-miss,kind);

%Include Missing 
mptr=InclMissAvTrY(ptr,AvTrY,kind);
ptr=[ptr mptr];


%
fprintf('AvTr:%d, AvDev:%d, ptr:%d, pdev:%d, pdevtr:%d\n',AvTr,AvDev,length(ptr),length(pdev),length(pdev_tr));



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function mptr=InclMissAvTrY(ptr,AvTrY,kind)
%Include Missing Available Training Labels (FUTURE: Improve not to take from Dev)
mptr=[];
lptr=length(ptr);
lAvTrY=length(AvTrY);

MPo=setdiff(unique(AvTrY),unique(AvTrY(ptr)));
for i=1:length(MPo)
    j=find(AvTrY==MPo(i)); %j missing index
    nj=length(j); %number of j 
    pj=nj/lAvTrY; %prob of j    
    tj=min(ceil(pj*lptr),nj); %take of j (ceil to be always at least 1)    
    %a=j(randperm(nj,tj)); 
    a=j(jrandperm(nj,tj,kind));    
    mptr=[mptr a];    
    fprintf('WARNING: forced inclusion of missing avaliable label %d (taken %d/%d samples)\n',MPo(i),tj,nj);    
end

