function [nn]=DbnTr(TrX,TrY,DevX,DevY,DBNModelDir)
%Train Deep Belief Network
%TrX,TrY,DevX,DevY must be shufled


%Pretraining Param
PP.sizes        = [256 256 256 256];
PP.alpha        = 0.004; %learning rate
PP.numepochs    = 100; %the more the better 
PP.initMomentum = 0.5;
PP.momentum     = 0.9;
PP.batchsize    = 100;
PP.weightcost   = 1e-4;
PP.firstLayerIsGaussian = 1;
PP.plot         = 0;

%Fine Tune Param
FTP.numepochs   =  130; %100 or 30
FTP.batchsize   = PP.batchsize;
FTP.plot        = PP.plot;
FTP.nLayer      = length(PP.sizes); %use this number of layers from pre-trained RBMs
FTP.learningRate = 0.005;
FTP.activation_function = 'sigm';
FTP.output      = 'softmax'; %Used only to estimate error in DbnFineTune->nntrain->nnff
%FTP.output = 'sigm'; 


%Training
TrX=TrX'; TrY=TrY'; 
DevX=DevX'; DevY=DevY'; 

DbnTrRBMStack(TrX,PP,DBNModelDir);
[nn]=DbnFineTune(TrX,TrY,DevX,DevY,FTP,DBNModelDir);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function DbnTrRBMStack(TrX,opts,DBNModelDir)
%
%TrX: each row is a frame; each column is a feature (5000*250)
%TrY: a row of labels for each frame (5000*5)


fprintf('Starting DbnTrRBMStack with TrX size of [%d %d]\n',size(TrX,1),size(TrX,2));

% PARAMS
%[s,m,mm] = rmdir(modelPath,'s'); 
[x,x,x]=mkdir(DBNModelDir);

% train stack of RBMs
dbn.sizes = opts.sizes;
opts.doPlotError = opts.plot;
opts.doSaveRBMs = true;
opts.savePath = DBNModelDir;
opts.evalInCallerString = 'clear TrX'; %TrX will be cleared from within dbntrain

%set number of samples to be an integer multiple of the minibatch size
nSample = size(TrX,1);
nSample = nSample - mod(nSample,opts.batchsize);
TrX = TrX(1:nSample,:);

fprintf('RBM setup and training\n')
dbn = dbnsetup(dbn, TrX, opts);
dbn = dbntrain(dbn, TrX, opts);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [nn]=DbnFineTune(TrX,TrY,DevX,DevY,FTP,DBNModelDir)
% Given a stack of pre-trained RBMs, fine tune the DBN using
% backpropagation.
%TrX: each row is a frame; each column is a feature (5000*250)
%TrY: a row of labels for each frame (5000*1)



% load RBM stack
load([DBNModelDir '/RBM_0'  num2str(FTP.nLayer) '.mat']); %FUTURE IMPROVEMENT: Take the last layer for more than 10 layers


opts.numepochs = FTP.numepochs;
opts.batchsize = FTP.batchsize;
opts.plot = FTP.plot;
opts.nLayer = FTP.nLayer;
opts.validation = 1;   


fprintf('Selecting first %d layers from pretrained DBNs\n',opts.nLayer);
dbn.rbm = dbn.rbm(1:opts.nLayer);
dbn.sizes = dbn.sizes(1:opts.nLayer+1);


%Compute number of Tr samples (must be multiple of minibatch) 
[nSample, ClN]=size(TrY);  
opts.nTrain = floor(1*nSample/opts.batchsize)*opts.batchsize; %Number of training samples
trainX = TrX(1:opts.nTrain,:);
trainY = TrY(1:opts.nTrain,:);
testX = DevX;
testY = DevY;


%unfold dbn to nn
nn = dbnunfoldtonn(dbn, ClN);
nn.activation_function = FTP.activation_function;
nn.output = FTP.output;
nn.learningRate = FTP.learningRate;

%Train and Test     
nn = nntrain(nn, trainX, trainY, opts,testX,testY);  
[er, bad] = nntest(nn, testX, testY);    
    








