function dbn = dbntrain(dbn, x, opts)
%
n = numel(dbn.rbm);

[firstLayerIsGaussian,opts] = checkParams(opts,'firstLayerIsGaussian',0);




[doSaveRBMs,opts] = checkParams(opts,'doSaveRBMs',false);
[savePath,opts] = checkParams(opts,'savePath',tempname);
[plotFilename,~] = checkParams(opts,'plotFilename','');
[evalInCallerString,opts] = checkParams(opts,'evalInCallerString',[]);
[resumeFromLayer,opts] = checkParams(opts,'resumeFromLayer',0); %for e.g. 1, assumes that first RBM has been trained already, 
%i.e. data is passed up to first layer and learning continues with 2nd layer.
[resumeFromModelFile,opts] = checkParams(opts,'resumeFromModelFile','');


%for large scale problems, it helps to clear memory in scope of caller
if(~isempty(evalInCallerString))
    evalin('caller',evalInCallerString);
end

if(~isempty(plotFilename))
    doSavePlot = 1;
else
    doSavePlot = 0;
end

if(resumeFromLayer==0)
    
   
    if(doSavePlot)
         [path,name,ext] = fileparts(plotFilename);
         name = [name '_1' ];
         opts.plotFilename = fullfile(path,[name,ext]);
    end
    
    if(firstLayerIsGaussian)
        optsGauss = opts;        
        
        optsGauss.contInput = 1;
        dbn.rbm{1} = rbmtrain(dbn.rbm{1}, x, optsGauss);
    else
        opts.contInput = 0;
        dbn.rbm{1} = rbmtrain(dbn.rbm{1}, x, opts);
    end
    
    if(doSaveRBMs)
        fln = fullfile(savePath,['RBM_' num2str(1,'%02d')]);
        save(fln,'dbn','opts');
    end
    
else
    
    fprintf('Loading existing DBN to resume training\n');
    tmp = load(resumeFromModelFile);
    for k=1:resumeFromLayer
        dbn.rbm{k} = tmp.dbn.rbm{k};
    end
end



for i = 2 : n
    fprintf('Passing data up to next layer\n')
    x = rbmup(dbn.rbm{i - 1}, x);
    if(isfield(opts,'valData'))
        opts.valData = rbmup(dbn.rbm{i - 1}, opts.valData);
    end
    
    if(doSavePlot)
         [path,name,ext] = fileparts(plotFilename);
         name = [name '_' num2str(i) ];
         opts.plotFilename = fullfile(path,[name,ext]);
    end
    
  
    if(i>resumeFromLayer)
        fprintf('training RBM %d ... \n',i);
        dbn.rbm{i} = rbmtrain(dbn.rbm{i}, x, opts);
        
        
        if(doSaveRBMs)
            system('kinit -R');
            system('aklog');
            fln = fullfile(savePath,['RBM_' num2str(i,'%02d')]);
            save(fln,'dbn','opts');
        end
    end
end

end
