function TrTeDBNExample
%Train and Test Deep Believ Network


%Paths
SoftRoot='/clusterFS/home/user/jamc/SPEECHDATA/Softwares';
SpeechRoot='/clusterFS/home/user/jamc/SPEECHDATA';

DBNToolRoot =[SoftRoot '/DBNToolbox'];
DBNModelsRoot=[SpeechRoot '/HMMs/DBNModels'];
P.DBNModelDir=[DBNModelsRoot '/DBN1'];


addpath([DBNToolRoot '/CAE']);
addpath([DBNToolRoot '/CNN']);
addpath([DBNToolRoot '/data']);
addpath([DBNToolRoot '/DBN']);
addpath([DBNToolRoot '/NN']);
addpath([DBNToolRoot '/SAE']);
addpath([DBNToolRoot '/tests']);
addpath([DBNToolRoot '/util']);


%Data
UtN=50;
FeatL=250;
UtFr=100;

X=randn(FeatL,UtN*UtFr); X=X';
Y=rand(1,UtN*UtFr)>0.5; Y=Y';

%
%TRAINING
trainRBMStack(X,Y,P);
finetuneDBN(X,Y,P);

% % %TEST
% load([P.DBNModelDir '/finetunedL4.mat']);
% nn=nnff(nn,X,Y);
% t=nn.a{end}; %class posterior 
% SoftD=t(:,1);
% plot(SoftD)

