function WrKaldFeatTr(feature_transform_txt,conf)
%Write Kaldi Feature transformation

%Remember: if x is with context, then Fe=(x+a).*b
ctx=conf{1}; 
a=conf{2};
b=conf{3};

CtxF=length(ctx); %Context Frames 11
FFL=length(a); %Final Frame Length 440
FL=FFL/CtxF; %Frame Length (before context) 40



%
fi=fopen(feature_transform_txt,'w');

fprintf(fi,'<Nnet>\n'); 
fprintf(fi,'<Splice> %d %d\n',FFL,FL); 
fprintf(fi,'[ '); fprintf(fi,'%d ',ctx); fprintf(fi,']\n'); 
fprintf(fi,'<AddShift> %d %d\n',FFL,FFL); 
fprintf(fi,'<LearnRateCoef> 0  [ '); fprintf(fi,'%.7g ',a); fprintf(fi,']\n'); %.7g is the Kaldi precision (check aslo WrKaldFeat)
fprintf(fi,'<Rescale> %d %d\n',FFL,FFL);
fprintf(fi,'<LearnRateCoef> 0  [ '); fprintf(fi,'%.7g ',b); fprintf(fi,']\n'); 
fprintf(fi,'</Nnet>\n');

fclose(fi);

%
fprintf('Written:%s\n',feature_transform_txt);


