function WrKaldFeat(features,ArkFN,ScpFN,KaldiRoot)
% Writes a set of features into an ARK file and an SCP file


pn=fileparts(ArkFN); system(['mkdir -p ' pn]); %delete if make slow the function



fid=fopen([ArkFN(1:end-3) 'txt'],'w');

l=length(features.utt);

fprintf('WrKaldFeat %d files to text....\n',l);
for utt_ind=1:l
    
   
    utt=features.utt{utt_ind};
    feature=features.feature{utt_ind};
    [nch, nfram]=size(feature);
    
    fprintf(fid,'%s  [\n ', utt);      
    %New
    fmt=[repmat(' %.7g',1,nch) ' \n ']; %.7g is the Kaldi precision (check aslo WrKaldFeat)
    fprintf(fid,fmt,feature);       
    %Old 
%     for t=1:nfram,         
%         fprintf(fid,' %.7g', feature(:,t));
%         fprintf(fid,' \n ');
%     end    
    fprintf(fid,' ]\n');    
    
end


fprintf('WrKaldFeat copy-feats.....\n');
fclose(fid);
system([KaldiRoot '/featbin/copy-feats --compress=true ark,t:' ArkFN(1:end-3) 'txt ark,scp:' ArkFN ',' ScpFN]); %remove [~,~]=system(.. to see future errors

system(['rm ' ArkFN(1:end-3) 'txt']);



fprintf('Written: %s\n',ArkFN);

return


