function [nnet]=ReSaKaldNNet(filename,KaldiRoot)
%Read (load) Save Kaldi Neural Network
%nnetBin: is .nnet

[pn, bn,ext]=fileparts(filename); Ext=ext(2:end); Ext(1)=upper(Ext(1));
ModelMat=[pn '/Mat' bn  Ext '.mat'];


%Save-Load heavy DNN
if ~exist(ModelMat,'file')
    fprintf('WARNING: Saving %s\n',ModelMat);
    
    %models=ReKaldGmm(filename,BinModel,KaldiRoot);  
    nnet=ReKaldNNet(filename,KaldiRoot);
    
    save(ModelMat,'nnet');    
end
fprintf('WARNING: Loading %s\n',ModelMat);

S=load(ModelMat);    nnet=S.nnet;















%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [nnet]=ReKaldNNet(nnetBin,KaldiRoot)
% [nnet]=readkaldiNNet(nnetBin) transforms neural netwrok in kaldi format 
% to matlab cell array containing the neural network parameters  
% Input arguments:
% nnetBin --> path to the neural network stored in Kaldi format  
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%                              
% Written by Ahmed Hussen Abdelaziz and Shinji Watanabe  
% Copyright(c) MERL 2014                                  
% Permission is granted for anyone to copy, use, or modify 
% this program for purposes of research or education. This program 
% is distributed without any warranty express or implied.   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Store an ASCII version of the neural network in the same folder of the
% binary one
TmpNNetASCI=[fileparts(nnetBin) '/TmpNNetASCI.txt'];
TmpNNetTxt=[fileparts(nnetBin) '/TmpNNet.txt'];

% Convert the binary network to an ASCII version 
system([KaldiRoot '/nnetbin/nnet-copy'...
        ' --binary=false'...
        ' ' nnetBin ...
        ' ' TmpNNetASCI]);

fid=fopen(TmpNNetASCI);
nnetChar=fscanf(fid,'%c');
fclose(fid);

starts=strfind( nnetChar , '[' );
ends=strfind( nnetChar , ']' );

% store the weights and the bias parameters of each layer in separate cell
nnet=cell([ 1 length(starts) ]);

for i=1:length(starts)
    fid=fopen(TmpNNetTxt,'w');
    fwrite(fid,nnetChar(starts(i)+1:ends(i)-1));
    fclose(fid);
    nnet{i}=dlmread(TmpNNetTxt);
end

delete(TmpNNetASCI,TmpNNetTxt);


