function models=ReSaKaldGmm(filename,BinModel,KaldiRoot)
%Read (load) Save  Kaldi Gmm
%Since ReSaKaldGmm is very slow this interface save in .mat for later load
%the model
%filename: is a .mdl 

[pn, bn, ext]=fileparts(filename); Ext=ext(2:end); Ext(1)=upper(Ext(1));
ModelMat=[pn '/Mat' bn Ext '.mat'];

%Save-Load heavy DNN
if ~exist(ModelMat,'file')
    fprintf('WARNING: Saving %s\n',ModelMat);
    models=ReKaldGmm(filename,BinModel,KaldiRoot);  
    save(ModelMat,'models');    
end
fprintf('WARNING: Loading %s\n',ModelMat);

S=load(ModelMat);    models=S.models;

