function features=ReKaldFeatArk(filename,KaldiRoot)
% Reads all features (utterance-basename and feature) from an ARK (not SCP)

%
fprintf('Reading Ark:%s\n',filename);

%
[pn,bn] = fileparts(filename);
TmpArkTxt=[pn '/Tmp' bn '.txt'];

%Write Ark in Txt
[~,~]=system([KaldiRoot '/featbin/copy-feats ark:' filename ' ark,t:' TmpArkTxt]);

%Read Txt and delete Txt
fid=fopen(TmpArkTxt,'r'); txt=fscanf(fid,'%c'); fclose(fid);
delete(TmpArkTxt);


%Structure Txt
features=struct('utt',cell(1),'feature',cell(1));
b=strfind(txt,'[');
e=[-1 strfind(txt,']')];
l=length(b);
features.utt=cell(l,1);
features.feature=cell(l,1);

fprintf('and converting of %d: \n',l);
for i=1:l
    
    if mod(i,30)==0; fprintf('\n'); else fprintf('%d ',i); end
    
    utt=txt(e(i)+2:b(i)-3);     
    a=txt(b(i):e(i+1));
    feature=eval(a).'; %Heavy function!!!!!!!!    
    features.utt{i}=utt;
    features.feature{i}=feature;
end


fprintf('. Read\n');