function features=ReKaldFeat(filename,KaldiRoot)
% Reads a set of features from an ARK or an SCP file
%Emmanuel algorithm for SCP asumes that the ARK is always the same. If it
%is not the case it reads several times the same ARK and takes long time.
%This new version read each ARK only once.

[pathstr,name,ext] = fileparts(filename); 




if (strcmp(ext,'.scp') || strcmp(ext,'.txt')) % SCP file
   
    [utt,arkf]=ReUttArkDicSpc(filename); 
    l=length(utt);
    AU=cell(1,l);
    AF=cell(1,l);    
    uarkf=unique(arkf);  
    in=1; 
    for i=1:length(uarkf)   
        
        %Read and find for one Ark
        Ark=ReKaldFeatArk(uarkf{i},KaldiRoot);
        j=strcmp(arkf,uarkf{i});        
        U=utt(j); 
        F=Key2ValDict(U,Ark.utt,Ark.feature,1);
        
        %Fill
        l=length(U);   
        AU(1,in:in+l-1)=U;        
        AF(1,in:in+l-1)=F;               
        in=in+l;   
    
    end
    
    %Put in order
    features.feature=Key2ValDict(utt,AU,AF,1);
    features.utt=utt;
    
    
    
%     features=struct('utt',cell(1),'feature',cell(1));
%     fid=fopen(filename,'r');
%  
%     
%     
%     utt_ind=1;
%     prevfile='';
%     while ~feof(fid),
%         txt=fgetl(fid);
%         b=strfind(txt,' ');
%         e=strfind(txt,':');
%         utt=txt(1:b-1);
%         arkfile=txt(b+1:e-1);
%         if ~strcmp(arkfile,prevfile),
%             %featuresfile=readkaldifeatures(arkfile);                
%             %featuresfile=ReKaldFeat(arkfile,KaldiRoot); %recursive call
%             featuresfile=ReKaldFeatArk(arkfile,KaldiRoot);
%             
%         end
%         uind=1;
%         while ~strcmp(featuresfile.utt{uind},utt),
%             uind=uind+1;
%         end
%         feature=featuresfile.feature{uind};
%         features.utt{utt_ind}=utt;
%         features.feature{utt_ind}=feature;
%         utt_ind=utt_ind+1;
%         prevfile=arkfile;
%     end
else                        % ARK file
    
    
    features=ReKaldFeatArk(filename,KaldiRoot);


end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [utt,ark]=ReUttArkDicSpc(filename)
%Read Utt Ark Dic from Spc
fid=fopen(filename,'r');
i=1;
while ~feof(fid),
    txt=fgetl(fid);
    b=strfind(txt,' ');
    e=strfind(txt,':');
    utt{i}=txt(1:b-1);
    ark{i}=txt(b+1:e-1);
    i=i+1;
end
fclose(fid);

    