function features=ReKaldFeat(filename,KaldiRoot)
% Reads a set of features from an ARK or an SCP file


[pathstr,name,ext] = fileparts(filename); 


if (strcmp(ext,'.scp') || strcmp(ext,'.txt')) % SCP file
   
    
    features=struct('utt',cell(1),'feature',cell(1));
    fid=fopen(filename,'r');
 
    
    
    utt_ind=1;
    prevfile='';
    while ~feof(fid),
        txt=fgetl(fid);
        b=strfind(txt,' ');
        e=strfind(txt,':');
        utt=txt(1:b-1);
        arkfile=txt(b+1:e-1);
        if ~strcmp(arkfile,prevfile),
            %featuresfile=readkaldifeatures(arkfile);                
            %featuresfile=ReKaldFeat(arkfile,KaldiRoot); %recursive call
            featuresfile=ReKaldFeatArk(arkfile,KaldiRoot);
            
        end
        uind=1;
        while ~strcmp(featuresfile.utt{uind},utt),
            uind=uind+1;
        end
        feature=featuresfile.feature{uind};
        features.utt{utt_ind}=utt;
        features.feature{utt_ind}=feature;
        utt_ind=utt_ind+1;
        prevfile=arkfile;
    end
else                        % ARK file
    
    
    features=ReKaldFeatArk(filename,KaldiRoot);


end