function Htk2KaldDir(ODir,IDir,Pref,TrTransDir,KaldiRoot)
%Htk To Kaldi Directory 
%Read all Htk files of a IDir and generate FeatScp, FeatArk and Text 

%Outputs
FeatScp=[ODir '/' Pref 'FeatScp.txt'];
FeatArk=[ODir '/' Pref 'Feat.ark'];
Text=   [ODir '/' Pref 'Text.txt'];


fprintf('Htk2KaldDir of %s\n',FeatScp);

%Read all Htk features and basenames (utt)
fy=dir([IDir '/*' Pref]);
l=size(fy,1);
feature=cell(l,1);
utt=cell(l,1);

for i=1:l
    [pn, utt{i}]=fileparts(fy(i).name);
    fn=[IDir '/' fy(i).name];
    feature{i}=ReadHTKF(fn,0,0);
end

%Write Ark and Scp for features
A.feature=feature;
A.utt=utt;
WrKaldFeat(A,FeatArk,FeatScp,KaldiRoot);

%Write text transcriptions
FeatScp2TexTran(Text,FeatScp,TrTransDir,IDir);


 
    

