function [PdfN]=PhN2PdfN(PhN,models)
%Phone Number To Pdf Number
%PhN: is a vector (from 1.....351 as in SilCsl)
%PdfN: is a cell (same length as PhN) (each element is a vector) From
%1.... NumOfPdf as in models (not 0...NumOfPdf-1 as in Kaldi)

TPh=models.TransitionModel.Triples(:,1); %Ph
%TSt=models.TransitionModel.Triples(:,2); %States
TPdf=models.TransitionModel.Triples(:,3); %Pdf

l=length(PhN);
PdfN=cell(l,1);
for i=1:l
    j=PhN(i)==TPh;
    PdfN{i}=unique(TPdf(j))';
end


