function TrImpGmm(FeatRoot,P,TrDir)
%Training Imputation Gmm


if nargin<3
    TrDir={ 'Dev/dt05_bus_simu'    'Dev/dt05_caf_simu' ...  
            'Dev/dt05_ped_simu'    'Dev/dt05_str_simu'};  
    [p1,b1]=fileparts(FeatRoot); [p2,b2]=fileparts(p1); [p3,b3]=fileparts(p2); 
    FeatRoot=p2;        
end


%Cell List of Htk files for training   
CList=[];
for i=1:length(TrDir)
    FeatDir=[FeatRoot '/' TrDir{i}];
    CList=[CList; LsBn12Ext(FeatDir,'','*','.Fbx')];    
end



%Train Gmm
TmpGmmDir=[P.ImputeGmmDir '/Tmp']; mkdir(TmpGmmDir);
TmpImpGmmF=[TmpGmmDir '/Gmm.mat'];
GmmTrain(TmpImpGmmF,CList,P.ImpNGaus,'diag',100);

%Copy final result
ImpGmmF=[P.ImputeGmmDir '/Gmm.mat'];
copyfile(TmpImpGmmF,ImpGmmF);
fprintf('Final ImpGmm in %s\n',ImpGmmF);

