function [gmmRel, gmmUn]= splitGMM( mix, y, mask )

u= length(find(~mask));
K= mix.ncentres;
N= mix.nin;

if u == 0
    gmmRel= mix;
    gmmUn= [];
elseif u == N
    gmmUn= mix;
    gmmRel= [];
else
    gmmRel= mix;
    gmmRel.nin= N-u;
    gmmRel.centres= zeros( K, N-u );
    
    gmmUn= mix;
    gmmUn.nin= u;
    gmmUn.centres= zeros( K, u );

    if strcmp(mix.covar_type,'diag')
        gmmRel.covars= zeros(K, N-u);
        gmmUn.covars= zeros(K, u);
    else
        if iscell( mix.covars )
            gmmRel.covars= cell(K,1);
            gmmUn.covars= cell(K,1);
        else
            gmmRel.covars= zeros(N-u, N-u, K);
            gmmUn.covars= zeros(u, u, K);
        end
    end

    %Split the mixtures into reliable and unreliable components
    for k= 1:K
        m= mix.centres(k,:)';
        m_r= m(mask);
        m_u= m(~mask);

        if strcmp(mix.covar_type,'diag')
            s= mix.covars(k,:)';
            s_r= s(mask);
            s_u= s(~mask);
            m_u_r= m_u;
            gmmRel.covars(k,:)= s_r;
            gmmUn.covars(k,:)= s_u;           
        else
            if iscell( mix.covars )
                S= mix.covars{k};
            else
                S= mix.covars(:,:,k);
            end
            [S_r, S_ur, S_u]= splitCovariance( S, mask );

            if isempty( find(full(abs(diag(S_r)))>1e-3, 1) )
                m_u_r= m_u;
                S_u_r= S_u;
            else
                mask2= mask & (full(abs(diag(S)))>1e-3);
                xr2= y(mask2);
                m_r2= mix.centres(k,mask2)';
                S_r2= S(mask2,mask2);
                S_ur2= S(~mask,mask2);
                A= S_ur2/S_r2;
                m_u_r= m_u + A*(xr2-m_r2); %Mean of the conditional Gaussian distribution of u given r
                S_u_r= S_u - A*S_ur2'; %Covariance of the conditional Gaussian distribution of u given r
            end

            if iscell( mix.covars )
                gmmRel.covars{k}= S_r;
                gmmUn.covars{k}= S_u_r;
            else
                gmmRel.covars(:,:,k)= S_r;
                gmmUn.covars(:,:,k)= S_u_r;
            end
        end

        gmmRel.centres(k,:)= m_r;
        gmmUn.centres(k,:)= m_u_r;
    end
end