function xest= softImpute( data, mask, gmm_x, MF)

%THR= 0.1;
THR= abs(MF)+0.1; %A bit more than abs(MF)

%--------------------------------------------------
% Function definition
%--------------------------------------------------

xest= data;
[params frames]= size(data);
K= gmm_x.ncentres;
px_y= zeros(params, K); %px(y|k)
Px_y= zeros(params, K); %Px(x<=y|k)
Xbound= zeros(params, K);
for t= 1:frames
    y= data(:,t);
    m= mask(:,t);

    %Precompute the probabilities used in the estimation and the partial
    %estimates
    for k= 1:K
        if strcmp(gmm_x.covar_type,'diag')
            px_y(:,k)= probability( y, gmm_x.centres(k,:)', gmm_x.covars(k,:)' );
            Px_y(:,k)= cumulativeProb( y, gmm_x.centres(k,:)', gmm_x.covars(k,:)' );
            Xbound(:,k)= boundedEstimate( gmm_x.centres(k,:)', gmm_x.covars(k,:)', px_y(:,k), Px_y(:,k) );
        else
            px_y(:,k)= probability( y, gmm_x.centres(k,:)', diag(gmm_x.covars(:,:,k)) );
            Px_y(:,k)= cumulativeProb( y, gmm_x.centres(k,:)', diag(gmm_x.covars(:,:,k)) );
            Xbound(:,k)= boundedEstimate( gmm_x.centres(k,:)', diag(gmm_x.covars(:,:,k)), px_y(:,k), Px_y(:,k) );
        end
    end
    
    % -- Compute the posteriors P(k|y) for every Gaussian
    %p(y|k)= m_i*px(y_i|k) + ((1-m_i)/y_i)*Px(x<=y_i)
    py= bsxfun(@times, px_y, m) + bsxfun(@times, Px_y, (1-m)./(y+THR)); 
    p= prod(py) .* gmm_x.priors;
    p= p/sum(p);

    %Combine the partial estimates according to their posterior
    %probabilities
    Xbound= bsxfun(@min, Xbound, y);
    xest(:,t)= m.*y + (1-m).*sum(bsxfun(@times, Xbound, p), 2);
end


%--------------------------------------------------------------------------
function p= probability( x, mean, sigma2 )
invs= 1./sqrt(sigma2);
z= invs.*(x-mean);
p= normpdf(z).*invs;


%--------------------------------------------------------------------------
function p= cumulativeProb( x, mean, sigma2 )
z= (x-mean)./sqrt(sigma2);
p= normcdf(z);


%--------------------------------------------------------------------------
function xest= boundedEstimate( mean, sigma2, px_y, Px_y )
q= sigma2.*px_y./Px_y;
q(isnan(q) | isinf(q))= 0;
xest= mean - q;
