function out= softImputation( data, mask, gmm, imputationAlgorithm )

switch imputationAlgorithm
    case 'bmap'
        impute= @softBmapImputation;
    case 'map'
        impute= @softMapImputation;
    case 'faubel'
        impute= @softBCMImputation;
    case 'faubel2'
        impute= @softBCMImputation2;
end

frames= size(data,2);
for i=1:frames
    y= data(:,i);
    m= mask(:,i);

    xest= zeros(size(y));
    norm= 0;
    for k=1:gmm.ncentres
        p= softBoundedProbability( y, m, gmm, k );
        norm= norm + p;
        xest= xest + p*impute( y, m, gmm, k );
    end
    data(:,i)= min([xest/norm y], [], 2); % -Inf <= xu(i) <= y(i)
end
out= data;
