function P= softBoundedProbability ( y, w, gmm, k, logProbs )

LOWER_BOUND= -Inf;

if nargin == 4
    logProbs= false;
end

%Bounded probability assuming diagonal covariance matrices
u= gmm.centres(k,:)';
if strcmp(gmm.covar_type,'diag')
    s= 1./sqrt(gmm.covars(k,:))';
%     S= diag(s);
else
    s= 1./sqrt(diag(gmm.covars(:,:,k)));
%     S= gmm.covars(:,:,k);
end

%Soft-bounded probability: p(k|y,w)= P(k) * p(w|k) * p(y|w,k) where
%p(y|w,k)= w*p(y|k) + (1-w)*\int_{-inf}^{y} p(x|k) dx

%1. Computation of p(y|k) assuming diagonal covariances
z= (y-u).*s;
pr= normpdf( z ).*s;
% pr= exp(-0.5*(y-u).^2./s) ./ sqrt(2*pi*s);
%pr= mvnpdf(y, u, S);

%2. Computation of \int_{-inf}^{y} p(x|k) dx assuming diagonal covariances
pu= normcdf(z).*s;

ck= gmm.priors(k); %Prior of the Gaussian k
if logProbs
    P= sum( log([ck; pr; pu]) ); %<<-- To be fixed
else
    P= prod( [ck; (w.*pr + (1-w).*pu) ] );
%     w2= (1-w)./(y+7); %Lower bound is -7
%     P= prod( [ck; (w.*pr + w2.*pu) ] );
end
