function out= restoreDataPrecision( dataWin, varWin, winIndexes, frames, params )
out= zeros(params, frames);
for t=1:frames
    i= find( winIndexes==t )';
    i2= (i-1)*params+1;
    i3= repmat(i2, params, 1);
    i4= bsxfun(@plus, i3, (0:params-1)');
   
    x_est= dataWin(i4);
    var= varWin(i4);   

    precision= 1./(var+0.1);
    confidence= bsxfun(@times, precision, 1./sum(precision,2)); %Confidence of the estimate obtained for every window

    out(:,t)= sum( x_est.*confidence, 2 ); %Weigthed average of the estimates computed by the imputation
end