function varargout= mapImputationFast( y, m, gmm, k )

if ~isempty( y(~m) )
    xu_est= gmm.centres(k,:)';

    if strcmp(gmm.covar_type,'diag')
        S_est= diag( gmm.covars(k,:) );        
    else
        if iscell(gmm.covars)
            S_est= full( gmm.covars{k} );
        else
            S_est= gmm.covars(:,:,k);
        end
    end
    
    est= min(xu_est, y(~m)); %Bounded imputation: 0<= xu(i) <= y(i)
else
    est= [];
    S_est= [];
end

varargout{1}= est;
if nargout > 1
    varargout{2}= S_est;
end