function gmmFbank= invGmmPCA( gmmPCA, pcaModel )

LAMBDA= 1;

%npcs= size(gmmPCA.centres, 2); %Number of principal components modeled with the GMM
npcs= gmmPCA.nin;
norig= length(pcaModel.mean); %Size of the original data
mu= pcaModel.mean; %Mean of the windowed data
P= pcaModel.eigVecs(:,1:npcs); %Projection matrix
R= pcaModel.eigVecs(:,npcs+1:end); %Projection-residual matrix
% F= pcaModel.eigVecs; %Full principal components matrix

%Get the residual variance of the principal components not considered in P
Sr= (R*R')*pcaModel.covariance*(R*R');
% Sr_pca= R'*pcaModel.covariance*R; %Residual variance in the PCA domain

gmmFbank= gmmPCA;
gmmFbank.nin= norig;
gmmFbank.covar_type= 'full';
%Convert the means of all the Gaussians
gmmFbank.centres= bsxfun(@plus, P*gmmPCA.centres', mu)';

%Convert the covariance matrices of all the Gaussians
gmmFbank.covars= zeros(norig, norig, gmmFbank.ncentres);
for k=1:gmmFbank.ncentres
    switch gmmPCA.covar_type
        case 'diag'
            S= diag(gmmPCA.covars(k,:));
        case 'full'
            S= gmmPCA.covars(:,:,k);
    end
    %The covariance of the data in the spectrogram domain is added to the
    %component covariance in order to avoid a rank deficient covariance
    %matrix
%     gmmRate.covars(:,:,k)= (1-LAMBDA)*(P*S*P') + LAMBDA*pcaModel.covariance; 
    gmmFbank.covars(:,:,k)= P*S*P' + LAMBDA*Sr;
    
    %Force the covariance matrix to be symmetric
    t_up= triu(gmmFbank.covars(:,:,k));
    t_down= triu(gmmFbank.covars(:,:,k), 1)';
    gmmFbank.covars(:,:,k)= t_up + t_down;

%     gmmRate.covars(:,:,k)= F*diag([diag(S); diag(Sr_pca)])*F';
end
