function P= boundedProbabilityDiagFast ( y, m, gmm_xr, gmm_xu, k )

%The input feature vector is splitted into its realible (xr) and unreliable
%(xu) parts
xr= y(m);
xu= y(~m);

%Probability of the reliable components
pr= 1;
if ~isempty(xr)
    ur= gmm_xr.centres(k,:)';
    if strcmp(gmm_xr.covar_type,'diag')
        sr= gmm_xr.covars(k,:)';
    else
        if iscell( gmm_xr.covars )
            sr= full( diag(gmm_xr.covars{k}) );
        else
            sr= diag(gmm_xr.covars(:,:,k));
        end
    end
    sr= 1./sqrt(sr);
    zr= sr.*(xr-ur);
    pr= normpdf(zr).*sr; %N(x;mu,sigma)= (1/sigma)*N(z;0,1) where z=(x-mu)/sigma
end

%Prob of an unreliable component
pu= 1;
if ~isempty(xu)
    uu= gmm_xu.centres(k,:)';
    if strcmp(gmm_xu.covar_type,'diag')
        su= gmm_xu.covars(k,:)';
    else
        if iscell( gmm_xu.covars )
            su= full( diag(gmm_xu.covars{k}) );
        else
            su= diag(gmm_xu.covars(:,:,k));
        end
    end
    zu= (xu-uu)./su;
    pu= normcdf( zu ); %We assume that the lower bound is -Inf
end

P= prod( [pr; pu] );
