function P= boundedProbabilityDiag ( y, m, gmm, k, logProbs )

LOWER_BOUND= -Inf;

if nargin == 4
    logProbs= false;
end

%Bounded probability assuming diagonal covariance matrices
u= gmm.centres(k,:)';
if strcmp(gmm.covar_type,'diag')
    s= gmm.covars(k,:)';
else
    if iscell( gmm.covars )
        s= full( diag(gmm.covars{k}) );
    else
        s= diag(gmm.covars(:,:,k));
    end
end

%The input feature vector is splitted into its realible (xr) and unreliable
%(xu) parts
xr= y(m);
xu= y(~m);

%Probability of the reliable components
pr= 1;
if ~isempty(xr)
    ur= u(m);
    sr= 1./sqrt(s(m));
    zr= sr.*(xr-ur);
    pr= normpdf(zr).*sr; %N(x;mu,sigma)= (1/sigma)*N(z;0,1) where z=(x-mu)/sigma
end

%Prob of an unreliable component
pu= 1;
if ~isempty(xu)
    uu= u(~m);
    su= sqrt(s(~m));
    zu= (xu-uu)./su;
    pu= normcdf( zu ); %We assume that the lower bound is -Inf
end

ck= gmm.priors(k); %Prior of the Gaussian k
if logProbs
    P= sum( log([ck; pr; pu]) );
else
    P= prod( [ck; pr; pu] );
end

