function xu_est= boundedConditionalMeanImputationSvd( y, m, gmm, k )

%The MMSE estimate is the unconditional mean of the unreliable components
if strcmp(gmm.covar_type,'diag')
    xu_est= boundedConditionalMeanImputationDiag( y, m, gmm, k );
%The MMSE estimate is the conditional mean given the reliable components
else
    xr= y(m);
    xu= y(~m);
    mu_r= gmm.centres(k,m)';
    mu_u= gmm.centres(k,~m)';
    S= gmm.covars(:,:,k);
    [Sr,Sur,Su]= splitCovariance(S, m);
    if isempty(xr)
        mu_u_r= mu_u;
        Su_r= Su;
    else
        zr= Sr \ (xr-mu_r); %z= inv(Sr) * (xr-mu_r)
        mu_u_r= mu_u + Sur*zr; %Mean of the conditional Gaussian distribution of u given r
        Su_r= Su - Sur*(Sr\Sur'); %Covariance of the conditional Gaussian distribution of u given r
    end
    [U D V]= svd( Su_r );
    B= diag(1./sqrt(diag(D))) * U';
    zu= B*(xu-mu_u_r);
    
    correction= B\(normpdf(zu)./normcdf(zu)); %We assume that the imputation lower bound is -Inf
    if any(isinf(correction)) || any(isnan(correction))
        correction= zeros(size(correction));
    end
    xu_est= mu_u_r - correction;
end
xu_est= min([xu_est y(~m)], [], 2); %Bounded imputation: 0<= xu(i) <= y(i)
