function PCAImputationSparse ( fileList, gmm, pcaModel, maskType, imputationAlgorithm, probComputation, byteOrder, computeVars )


%------------------------------------------------------------------------
% CHECK THE PROGRAM ARGUMENTS 
%------------------------------------------------------------------------

if nargin < 8
    computeVars= 0;
else
    computeVars= str2num( computeVars );
end

if nargin < 7
    byteOrder= 'l'; %Big-endian
end

if nargin < 6
    probComputation= 'diag';
end

if nargin < 5
    imputationAlgorithm= 'map'; %Alteratively, imputationAlgorithm='map', imputationAlgorithm='faubel'
end

if nargin < 4
    maskType= 'binary'; %{'soft','binary'};
end

switch maskType
    case 'binary'
        impute= @binaryImputationFast;
    case 'fb'
        impute= @forwardBackwardImputationFast;
    case 'soft'
        impute= @softImputation;
    otherwise
        disp(['Error: unknown mask type ' maskType]);
        return;
end


%------------------------------------------------------------------------
% PROGRAM STARTS 
%------------------------------------------------------------------------

%Read the list of files with: inputFile inputMask outputFile
[listIn, listMask, listOut]= textread( fileList, '%s %s %s' );
nfiles= length(listIn);

%Read the mix variable on the gmm file
load(gmm, 'mix');

%Read the pca model
load(pcaModel, 'model');
winlen= model.winLen;
winshift= model.winShift;

%Convert the GMM from the PCA space to the spectral space
mix2= invGmmPCA( mix, model );

%Obtain sparse covariance matrices
mixSparse= sparseCovariance( mix2, winlen );

% mse= zeros(5,1);
% mse= 0;
% tic
for f=1:nfiles
    disp( ['Processing file ' num2str(f) '/' num2str(nfiles) ' ...'] );
    
    %Read the input speech file and apply a window
    [data, frmPeriod, sampKind]= readhtk(listIn{f}, byteOrder);
    [params frames]= size(data);
    [dataWin indexes]= enventana3 ( data, winlen, winshift );

    %Read the missing-data mask (HTK format)
    mask= readhtk( listMask{f}, byteOrder );
    maskWin= enventana3 ( mask, winlen, winshift );
    if strcmp(maskType, 'binary') || strcmp(maskType, 'fb')
        maskWin= (maskWin==1);
    end
    
%      [path, name, ext]= fileparts( listIn{f} );
%      cleanFile= ['Aurora2/fbank/clean1/' name ext];
%      cf= readhtk( cleanFile, byteOrder );
%     mse(1)= mse(1) + sum((cf(:)-data(:)).^2);
    
    %Impute the noise corrupted features
    if computeVars
        [imputedData varImputation]= impute( dataWin, maskWin, mixSparse, imputationAlgorithm, probComputation );
%         rd1= restoreDataAvg( imputedData, maskWin, indexes, frames, params );
%         rd2= restoreDataMSE( imputedData, varImputation, indexes, frames, params );
%         rd3= restoreDataPrecision( imputedData, varImputation, indexes, frames, params );
        rd4= restoreDataVar( imputedData, varImputation, indexes, frames, params );
% 	    writehtk( [listOut{f} '.avg'], rd1, frmPeriod, sampKind, byteOrder);
%         writehtk( [listOut{f} '.mse'], rd2, frmPeriod, sampKind, byteOrder);
%         writehtk( [listOut{f} '.prc'], rd3, frmPeriod, sampKind, byteOrder);
        writehtk( listOut{f}, rd4, frmPeriod, sampKind, byteOrder);
        
%         subplot(411), imagesc(rd1), axis xy;
%         subplot(412), imagesc(abs(rd1-rd2)), axis xy;
%         subplot(413), imagesc(abs(rd1-rd3)), axis xy;
%         subplot(414), imagesc(abs(rd1-rd4)), axis xy; pause;
%         mse(2)= mse(2) + sum((cf(:)-rd1(:)).^2);
%         mse(3)= mse(3) + sum((cf(:)-rd2(:)).^2);
%         mse(4)= mse(4) + sum((cf(:)-rd3(:)).^2);
%         mse(5)= mse(5) + sum((cf(:)-rd4(:)).^2);
    else
        imputedData= impute( dataWin, maskWin, mixSparse, imputationAlgorithm, probComputation );
        restoredData= restoreDataAvg( imputedData, maskWin, indexes, frames, params );
	    writehtk(listOut{f}, restoredData, frmPeriod, sampKind, byteOrder);
%         mse= mse + sum((cf(:)-restoredData(:)).^2);
    end    
end
% log(mse/nfiles)
% toc
% 
% mse= mse/nfiles;
% disp( ['MSE noisy: ' num2str(mse(1)) ] );
% disp( ['MSE Imp-Avg: ' num2str(mse(2)) ] );
% disp( ['MSE Imp-MSE: ' num2str(mse(3)) ] );
% disp( ['MSE Imp-Prec: ' num2str(mse(4)) ] );
% disp( ['MSE Imp-Var: ' num2str(mse(5)) ] );


%--------------------------------------------------------------------------
function gmmOut= sparseCovariance( gmmIn, win )

VAR_THR= 1; %A VAR_THR percent of the variance is discarded

gmmOut= gmmIn;
if strcmp(gmmIn.covar_type, 'full')
    K= gmmIn.ncentres;
    n= gmmIn.nin;
    norig= n/win;
    d= -n+norig:norig:n+norig; %Main diagonal indexes
    gmmOut.covars= cell(K,1);
   
    for k= 1:K
        S= gmmIn.covars(:,:,k);
        D= spdiags(S, d); %Matrix with the main diagonals of S
        
        if VAR_THR >= 1
            S2= spdiags(D, d, n, n);
        else
            v= sort(abs(S(:)));
            v2= cumsum(v)/sum(v);
            i= find(v2>=VAR_THR, 1);
            thr= v(i);
            S2= S;
            S2(abs(S2)<thr)= 0;
            S2= spdiags(D, d, S2);
        end
        S2= sparse( S2 );

        % This code is probably more robust to warranty positiveness:
        s1= eigs(S2, 1, 'sm');
        s2= eigs(S2, 1, 'sa');
        lambda = min([s1 s2]);
        if lambda < 0
            lambda = max(abs(lambda), eps(max(diag(S2)))*length(S2));
            S2= S2 + 2*lambda*speye(size(S2));
        end

        gmmOut.covars{k}= S2;
    end
end
