function OcclusionMaskEstimation ( fileList, gmm, byteOrder )

%------------------------------------------------------------------------
% CHECK THE PROGRAM ARGUMENTS 
%------------------------------------------------------------------------

if nargin < 3
    byteOrder= 'l'; %Big-endian
end

%------------------------------------------------------------------------
% PROGRAM STARTS 
%------------------------------------------------------------------------

%Read the list of files
[listIn, listNest, listNvar, listMask]= textread( fileList, '%s %s %s %s' );
nfiles= length(listIn);

%Read the mix variable of the gmm file
load(gmm, 'mix');

for f=1:nfiles
    disp( ['Processing file ' num2str(f) '/' num2str(nfiles) ' ...'] );
    
    %Read the input speech file
    [data, frmPeriod, sampKind]= readhtk(listIn{f}, byteOrder);
    
    %Read the noise estimates and their corresponding variances
    nest= readhtk(listNest{f}, byteOrder);
    nvar= readhtk(listNvar{f}, byteOrder);    

    %Estimate the clean features
    mask= ome( data, nest, nvar, mix );

    %Save the imputed ratemap
    writehtk(listMask{f}, mask, frmPeriod, 9, byteOrder);
end
