function OcclusionEstimation ( fileList, gmm, byteOrder )

%------------------------------------------------------------------------
% CHECK THE PROGRAM ARGUMENTS 
%------------------------------------------------------------------------

if nargin < 3
    byteOrder= 'l'; %Big-endian
end

%------------------------------------------------------------------------
% PROGRAM STARTS 
%------------------------------------------------------------------------

%Read the list of files
[listIn, listNest, listNvar, listEst]= textread( fileList, '%s %s %s %s' );
nfiles= length(listIn);

%Read the mix variable of the gmm file
load(gmm, 'mix');

% mse1= 0;
% mse2= 0;
% tic
for f=1:nfiles
    disp( ['Processing file ' num2str(f) '/' num2str(nfiles) ' ...'] );
    
    %Read the input speech file
    [data, frmPeriod, sampKind]= readhtk(listIn{f}, byteOrder);
    
    %Read the noise estimates and their corresponding variances
    nest= readhtk(listNest{f}, byteOrder);
    nvar= readhtk(listNvar{f}, byteOrder);    

    %Estimate the clean features
    xest= osr( data, nest, nvar, mix );

%     [path, name, ext]= fileparts( listIn{f} );
%     cleanFile= ['Aurora2/fbank/clean1/' name ext];
%     cf= readhtk( cleanFile, byteOrder );
%     mse1= mse1 + sum(sum((cf-data).^2));
%     mse2= mse2 + sum(sum((cf-imputedData).^2));

    %Save the imputed ratemap
    writehtk(listEst{f}, xest, frmPeriod, sampKind, byteOrder);
end
% toc
% 
% disp( ['MSE noisy: ' num2str(mse1) ] );
% disp( ['MSE imputed: ' num2str(mse2) ] );
