function [Xi,Yi,Ei]=TrHEqFList(MatC,Me,Std,Mi,Ma)
%Train Hitogram Equalization (find transformation) of a FList
%Convert to Normal (no Uniform) distribution 


NB=200; %Number of Bins (100 if Me+-4*Std, 200 if Mi, Ma)
[Ei,Xi]=MeStd2EdgesM(Me,Std,Mi,Ma,NB);
%
NLab=length(MatC);
nch=size(Ei,1);
Ct=zeros(nch,NB);
fprintf('Of %d:\n',NLab);
for i=1:NLab
%for i=[2 3 4 200 201]
    fprintf('%d ',i); if mod(i,30)==0; fprintf('\n'); end
    [Fe]=LoChFePoPh(MatC{i});   
    C=HistCountM(Fe,Ei);        
    Ct=Ct+C;    
end
[Pdf,Cdf,Yi]=HistCount2PdfCdfHEqTr(Ct,'Uniform');



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [E,Cent]=MeStd2EdgesM(Me,Std,GMi,GMa,NB)
%Me, Std To Edges Matrix (fast)
nch=length(Me);

% Ma=Me+4*Std;
% Mi=Me-4*Std;
Ma=GMa;
Mi=GMi;

% subplot(211), plot(GMi), hold on, plot(Mi,'r'), hold off
% subplot(212), plot(GMa), hold on, plot(Ma,'r'), hold off
% pause


d=(Ma-Mi)/NB;
E=zeros(nch,NB+1); %Egdes must be 1 more
Cent=zeros(nch,NB);
for ch=1:nch    
    E(ch,:)=Mi(ch):d(ch):Ma(ch);      
end
for ch=1:nch
    for i=1:NB
        Cent(ch,i)=(E(ch,i)+E(ch,i+1))/2;
    end
end



