function [Pdf,Cdf,Yi]=HistCount2PdfCdfHEqTr(Count,k)
%For Normal (no uniform) distribution
[nch,NB]=size(Count);
N=sum(Count,2);
Pdf=Count./repmat(N,[1,NB]);
Cdf=cumsum(Pdf,2); Cdf(Cdf>1)=1; %to avoid NaN in icdf

switch k
    case 'Normal'
        Yi=icdf('Normal',Cdf,0,1); %could be Inf
    case 'Uniform'
        NG=7;
        Yi=icdf('Uniform',Cdf,-0.57*NG,0.57*NG); %could be Inf
        
end
