function Y=ChHistEq(X,HEX,HEY)
%Channel Histogram Equalization
[nch,nf]=size(X);
Y=zeros(nch,nf);
for ch=1:nch
    x=HEX(ch,:); mi=min(x); ma=max(x);
    v=HEY(ch,:); 
    xq=X(ch,:);  xq(xq<mi)=mi; xq(xq>ma)=ma;     %To avoid NaN (interpolate out of domains)      
    vq=interp1(x,v,xq);         
    Y(ch,:)=vq;
end


%
i=isinf(Y);
if sum(i(:))>0
    warning('Detected Inf');    
    ma=max(Y(not(i)));
    mi=min(Y(not(i)));
    Y(i&Y>0)=ma;
    Y(i&Y<0)=mi;
end

