function GmmTrain(gmmFile,CellList,gaussians,covType, FNPerc)
%
%FNPerc: File Number Percentage (80)
%gmmFile='/home/roter/CDTesis/Puente12/ScriptMatlab/Common/VTS_Impute/GMM/gmmA4.diag.256.mat'; 
%covType='diag'; %mixed (1 gmm diag, full itera), 

trainMethod='voicebox'; 
byteOrder='b';

trainGMM(gmmFile, CellList, gaussians, covType, trainMethod, byteOrder, FNPerc)



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function trainGMM( gmmFile, CellList, gaussians, covType, trainMethod, byteOrder, FNPerc)
%

MAX_ITER= 100;
MAX_ITER_REF= 15;
%RandStream.setDefaultStream (RandStream('mt19937ar','seed',sum(100*clock)));
RandStream.setGlobalStream (RandStream('mt19937ar','seed',sum(100*clock)));


if nargin < 6
    byteOrder= 'b'; %Big-endian
end

ngauss= str2num(gaussians);
if ngauss <= 0
    error('trainGMM:argChk', 'The number of Gaussians must be greater than 0!');
end

if ~strcmp(covType,'diag') && ~strcmp(covType,'full') && ~strcmp(covType,'mixed')
    error('trainGMM:argChk', 'The type of the covariance matrix [%s] must be: diag, full or mixed', covType);
end

if nargin < 5
    trainMethod= 'voicebox';
end

switch trainMethod
    case 'netlab'
        gmmTraining= @netlabGMM;
    case 'voicebox'
        gmmTraining= @voiceboxGMM;
end

%Juan Code
%list= textread( trainList, '%s' );
list=CellList;


FN=length(list); numFiles=FN; 
p=randperm(numFiles); list=list(p); %shuffle files



if FNPerc<100
    numFiles= round(FN*(FNPerc/100));
    fprintf('WARNING: select %d files from %d\n',numFiles,FN);
end
    
%Allocate space for the training data
disp( '1.- Reading the training data' );
disp( '=============================' );
N= 0;
P= 0;
for f=1:numFiles
    fprintf('Alloc. %d/%d\n',f,numFiles)
    %data= readhtk( list{f}, byteOrder );
    data=ReadHTKF(list{f},0,0);      
    [params frames]= size(data);
    N= N+frames;
    if f == 1
        P= params;        
    elseif params ~= P
        error( 'trainGMM:fileChk', 'The number of speech parameters in the files differs!' );
    end
end

%Read the data
DATA= zeros(N,P);
n= 1;
for f=1:numFiles
    fprintf('Load. %d/%d\n',f,numFiles)
    %data= readhtk( list{f}, byteOrder );
    data=ReadHTKF(list{f},0,0);    
    frames= size(data, 2);
    DATA(n:n+frames-1,:)= data';
    n= n+frames;
end




disp( '2.- Training the GMM' );
disp( '====================' );
if strcmp(covType, 'mixed')
    %First, a diagonal covariance matrix GMM is trained    
    mix= gmmTraining(DATA, ngauss, 'diag', MAX_ITER);
    
    save( [gmmFile '.diag.mat'], 'mix' );

    %Second, the GMM is refined to obtain full covariances
    disp( 'Refining the diag GMM to obtain full covariances' );
    mixFull= gmm(P, ngauss, 'full');
    mixFull.priors= mix.priors;
    mixFull.centres= mix.centres;
    for k=1:ngauss   
        mixFull.covars(:,:,k)= diag(mix.covars(k,:));
    end
    mix= gmmTraining(DATA, ngauss, 'full', MAX_ITER_REF, mixFull);
else  
  
    fprintf( 'In gmmTraining.....'); 
    mix= gmmTraining(DATA, ngauss, covType, MAX_ITER); 
    fprintf( 'finished gmmTraining\n');
end

%Save the GMM
[pn bn]=fileparts(gmmFile);
mkdir(pn);

fprintf( '3.- Saving the GMM: %s\n',gmmFile);
fprintf( '====================\n' );
save( gmmFile, 'mix' ); 


%-------------------------------------------------------------------------
function mix= netlabGMM ( data, ngauss, covType, maxIter, initMix )

nparams= size(data, 2);

if nargin < 4
    maxIter= 100;
end

%Set up the mixture model
if nargin < 5
    mix= gmm(nparams, ngauss, covType);
    
    %Initialise the GMM with the k-means algorithm
    disp( 'Initialising the GMM with the k-means algorithm' );
    options = foptions;
    options(1)= 1;		% Prints out error values.
    options(14) = 20;	%20 iterations of k-means in initialisation
    mix = gmminit(mix, data, options);
else
    mix= initMix;
end

disp ( ['Training a ' covType ' covariances GMM with' ngauss ' Gaussians with the EM algorithm']);
options= zeros(1, 18);
options(1)= 1;		% Prints out error values.
options(3)= 1e-4;   % Ending condition defined by absolute error between iterations
options(5)= 1;      % Reset covariance matrix when singular values are too small
options(14)= maxIter;	% Number of iterations.
mix= gmmem(mix, data, options);


%-------------------------------------------------------------------------
function mix= voiceboxGMM ( data, ngauss, covType, maxIter, initMix )
nparams= size(data, 2);

if nargin < 4
    maxIter= 100;
end

%Set up the mixture model
if nargin < 5
    if strcmp(covType, 'full')
        initMethod= 'hfv';
    else
        initMethod= 'hf';
    end

    disp ( ['Training a ' covType ' covariances GMM with ' num2str(ngauss) ' mixtures with the EM algorithm'] );
    [m,v,w,g,f,pp,gg]= gaussmix(data, [], maxIter+1e-4, ngauss, initMethod);
    for i=1:length(gg)       
        disp( ['It. ' num2str(i) ' LogProb: ' num2str(gg(i))] );
    end    
    mix= gmm(nparams, ngauss, covType); %.nparams?? .ncentres, .covar_type
    mix.priors= w';
    mix.centres= m;
    mix.covars= v;
    
    
else
    mix= initMix;
    
    disp ( ['Training a ' covType ' covariances GMM with the EM algorithm'] );
    [m,v,w,g,f,pp,gg]= gaussmix(data, [], maxIter+1e-4, mix.centres, mix.covars, mix.priors');
    for i=1:length(gg)
        disp( ['It. ' num2str(i) ' LogProb: ' num2str(gg(i))] );
    end
    mix.priors= w';
    mix.centres= m;
    mix.covars= v;
end
