function [Ao,ToOc,ScPo]=Lin2LogSampTrans(A,FSampHz,NTo,MiToHz,MaToHz)
%Linear To Log (in Sample) Transformation (the rows of A are "piano"
%scaled between MiToHz-MaToHz)
%
%A:             OSA Autocorrelagram or equivalent. row: OSA (r(0) r(1)...), col: frames
%NTo:           Number of Tones between [MiToHz,MaToHz]
%
%ToOc:          Tones per Octave
%ScPo:          Scale in Positions (correspondences from A rows). Obeserve
%first index correspond always to 1 and that after a index they are 0.
%These 0s mean not correspondence in A. These happen when MiToHz is very
%low (<30 Hz).

%
ToOc=NTo/log2(MaToHz/MiToHz); 

%
x=(NTo-1:-1:0)/(NTo-1);
ToHz=MiToHz*((MaToHz/MiToHz).^x);
ToSa=FSampHz./ToHz;
ScPo=round(ToSa)+1; 

[MaPo, nf]=size(A); li=find(ScPo>MaPo,1,'first');
ScPo(1)=1; ScPo(li:end)=1;

%
Ao=A(ScPo,:); 
Ao(li:end,:)=0; ScPo(li:end)=0;


