function y=HzToErbRate(x)

% HZTOERBRATE Convert Hz to ERB rate.
% 
% SYNTAX
% 
%     Y = HZTOERBRATE(X)
% 
% 
% DESCRIPTION
% 
% Y = HZTOERBRATE(X) converts the frequency X (in Hz) to the eqivalent ERB
% number.
% 
% 
% See also ERBRATETOHZ

y=(21.4*log10(4.37e-3*x+1));

% Copyright 2010, Chris Hummersone and University of Surrey
% 
% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
% EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT 
% OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS 
% BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION 
% OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
% WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.