function [r0,TG,A,An,ScPo]=CG2StEnCoAc(CG,CGe,k,P)
%CochleaGram  To Standard-Envelope Combined AutoCorrelation


A=CGToCoAc(CG,CGe,P);

switch k
    case 'Log'
        [A,ToOc,ScPo]=Lin2LogSampAcTrans(A,P.FSamp,300,16,1000);
    case 'Lin'
        ScPo=1:size(A,2);
end

[An,r0,TG]=Ac2AnR0TG(A); 





%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [An,r0,TG]=Ac2AnR0TG(A)
%Ac2AnR0TG(A)
[nch, nk, nf]=size(A);
r0=A(:,1,:); r02=repmat(r0,[1 nk]); 
r0=squeeze(r0); %Fb=log(sqrt(P.FL*r0/2)); Fb(Fb<P.MF)=P.MF;  
An=A./r02;
i=(An<0.75); A(i)=0; An(i)=0;

TG=squeeze(sum(sqrt(A))); 





TG(TG<0)=0; TG=sqrt(TG); 
r0(r0<0)=0; r0=sqrt(r0);




function A=CGToCoAc(CG,CGe,P)
%
%
[As,x,r0]=CG2ACG(CG,P.nf,P);  
[Ae,x,r0e]=CG2ACG(CGe,P.nf,P);  
%
[nch, nk, nf]=size(As);
Am=sqrt(r0*2);
Ame=sqrt(r0e*(8/3));
i=Am>2*Ame;
A=Ae;
for c=1:nch    
        ii=i(c,:);
        A(c,:,ii)=As(c,:,ii);   
end
