function [Ay,NAy,r0]=CG2ACG(CG,onf,P)
%CochleaGram To AutoCorreloGram
%Heavy computation but very optimized (Feb2015)



%Ay=BCorrelogramModelFGT(y,50,8000,P.NCH,P.FSamp,50,P.FSSec*1000); %Ning
%code (0.9 sec)


Ay=ObtAy(CG,P,onf); %0.8 sec
[NAy,r0]=NormAy(Ay); %0.06 sec


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [Ay]=ObtAy(CG,P,onf)
%
[NCH N]=size(CG);
Ay=zeros(NCH,P.FL,onf);
AMy=zeros(P.FL,onf*NCH);
for c=1:NCH 
    [My, nf]=Segmx(CG(c,:),P.FL,P.FS);   
    int=(c-1)*onf+1:c*onf;    
    AMy(:,int)=My;  
end


[R]=M2ACNMe(AMy,'osau');  %0.58 sec


for c=1:NCH    
    int=(c-1)*onf+1:c*onf;      
    Ay(c,:,:)=R(:,int);   
end




function [NAy,r0]=NormAy(Ay)
%
[NCH,FL,nf]=size(Ay); 
r0=Ay(:,1,:);
r02=repmat(r0,[1 FL]); 
NAy=Ay./r02;
r0=squeeze(r0);


function  [R] =M2ACNMe(M,k)
%Segmented Matrix To AutoCorrelation with Normalized Mean
%M: segmented Matrix of the signal 
%Rb:    Ac all biased
%Rosab: Ac OSA (One Side Autocorrelation) biased 
%Rosau: Ac OSA (One Side Autocorrelation) unbiased

[FL,nf]=size(M);
Me=repmat(mean(M),[FL,1]); M=M-Me; %0.07

% 
% tic
% %Using fft (very fast) %0.44 sec
% x_pad = [M; zeros(FL,nf)]; %0.16 sec
% %X_psd = fft(x_pad).*conj(fft(x_pad))/FL;
% %X_fft=fft(x_pad); X_psd = abs(X_fft).^2/FL;
% X_fft=fft(x_pad); X_psd = X_fft.*conj(X_fft)/FL; %faster of the 3 %0.27 sec
% r_xx = ifft(X_psd); 
% Rosab=r_xx(1:FL,:);
% toc


a=fft(M,2*FL-1);
r_xx = ifft((abs(a).^2));
%r_xx = ifft(a.*conj(a)); 
Rosab=r_xx(1:FL,:)/FL;

switch k    
    case 'osab'
        R=Rosab;
    case 'osau'  
        R=Bi2UnOsa(Rosab);   
    case 'b'
        R=[Rosab(FL:-1:2,:); Rosab];        
    case 'u'
        Rosau=Bi2UnOsa(Rosab);
        R=[Rosau(FL:-1:2,:); Rosau];           
end 



% %To Check, Using xcorr (very slow)
% R=zeros(2*FL-1,nf); for i=1:nf; x=M(:,i); R(:,i)=xcorr(x,x,'unbiased');end, Rosa=R(FL:end,:);
% for i=1:nf; i,plot(Rosa(:,i)), hold on, stem(Rosau(:,i),'r'), hold off, pause; end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function Ru=Bi2UnOsa(Rb)
%From Biased to Unbiased an Osa
[FL nf]=size(Rb);
w=FL./(FL:-1:1)'; w=repmat(w,1,nf); Ru=Rb.*w;