function PseudoLL=VadEnhProb(OLPost,OPost,LPrior,models,P)
%Vad Enhancement Probabilities (Like or Post)
%vad: can be smooth


%P.SpFN=0.7; %Speech Factor (0.5, 0.7, 0.9, 0.99, 1)
fprintf('SpFN:%d\n',P.SpFN);

%Read silence phone numbers
fi=fopen(P.SilCsl,'r'); C = textscan(fi,'%d:'); SiPhN=C{:}'; fclose(fi);
%PhC=PhN2Ph({SiPhN},P.PhPhNDic);

%Find corresponding SiPdf and SpPdf
[NPdf,nf]=size(OPost); [SiPdfC]=PhN2PdfN(SiPhN,models); [SiPdfA,in,en]=Cell2M(SiPdfC); SiPdf=unique(SiPdfA);
SpPdf=setdiff((1:NPdf),SiPdf);


%Sp and Si Factors
SpF=P.VadPr*P.SpFN+(1-P.VadPr)*(1-P.SpFN); SiF=1-SpF;

% subplot(311), jplot(P.VadPr)
% subplot(312), jplot(SpF)
% subplot(313), jplot(SiF)
% pause



%Weigth 
W=zeros(NPdf,nf);
W(SpPdf,:)=repmat(SpF,[length(SpPdf),1]);
W(SiPdf,:)=repmat(SiF,[length(SiPdf),1]);


%The normalization does not have effect and the log-equivalences are right
%Bad results if: LPost=log(OPost.^W); perhaps due to overflow
%CONCLUSION: only LPost=OLPost.*W; and LPost=OLPost+log(W); make sense

%1) Simplest
LPost=OLPost+log(W);






% subplot(311), jimagesc(log(OPost)), title('Posterior')
% subplot(312), jimagesc(W), title('VAD Weight')
% subplot(313), jimagesc(LPost), title('Weigthed Posterior')
% pause


%
PseudoLL=LPost-repmat(LPrior,[1,nf]); 


% subplot(411), jplot(vad)
% subplot(412), jimagesc(W)
% subplot(413), jimagesc(log(Post))
% subplot(414), jimagesc(log(Post2))
% pause


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function B=NormCol(A)
%
[FL,nf]=size(A);
s=sum(A); s(s==0)=realmin;
B=A./repmat(s,[FL,1]);




