function [vad3]=Vad4NTr(vad,CFr,kind)
%Vad For Noise Transformation
%vad: vad with previous context



nf=length(vad);

switch kind
    case 0 %Chi3 noise       
        vad2=ones(1,nf);
        vad2(1:CFr)=0;        
    case 1 %2 Fr 
        vad2=ReduceVad(vad,CFr,2);
    case 2 %4 Fr
        vad2=ReduceVad(vad,CFr,4);
        
end






vad3=CheckVad(vad2,CFr);


% subplot(411), jplot(ye)
% subplot(412), jplot(vad)
% subplot(413), jplot(vad2)
% subplot(414), jplot(vad3)
% pause

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function vad2=ReduceVad(vad,CFr,Slots)
%Reduce Vad
vad2=vad;
vad2(Slots*CFr:end)=1;


function vad2=CheckVad(vad,CFr)
%
MiN0=round(CFr/4);

N0=sum(not(vad));
if N0<MiN0
    vad2=vad;    
    vad2((CFr-MiN0):CFr)=0;
    fprintf('WARNING: we add zeros around beggining in vad because not enough\n');
else
    vad2=vad;
end



