function [embs,Fs]=ReChi3Emb(S,ExSamp,y)
%Read Chime3 Embeded using info structure

embf=S.embf;
info = audioinfo(embf); 
Fs=info.SampleRate; lemb=info.TotalSamples;

s=round(S.s*Fs); 
e=round(S.e*Fs);

if e-s~=length(y)
    fprintf('WARNING in ReChime3Emb: size(emb)~=size(y)\n');
end

%Read s-ExSamp and e+ExSamp
%fs=s-ExSamp;
%fe=e+ExSamp;

%Read from s  after s (until the previous sample of y(1))
fs=s-ExSamp;
fe=s;

%Check
fs=max(1,fs);
fe=min(lemb,fe);

%
[embs,Fs]=audioread(embf,[fs+1, fe]);




