function Lat2Wer(Wer,LatGz,do,bn,P)
%Lattice To Word Error Rate
% Wer: WER file
% LatGz: Lattice (generate in Feat2Lat)
% do: output dir 
% bn: basename
% P: Parameter structure





[pn, TeK]        =fileparts(do);
TestDir          =[P.RecRoot '/RecStages/TestGen/TestDir/' P.SDBase];
WList            =[TestDir '/' P.RecPref 'WList.txt'];



TempScor=  [do '/TempScor' bn '.txt'];
TempTTran= [do '/TempTTran' bn '.txt'];
TempETran= [do '/TempETran' bn '.txt'];
Log      = ['/tmp/LogLat2Wer.txt'];

%LatGz to TempScor
c=[P.KaldiRoot '/latbin/lattice-scale --verbose=0 --inv-acoustic-scale=4 ' ...
   '"ark:gunzip -c ' LatGz '|" ark:- | ' P.KaldiRoot '/latbin/lattice-add-penalty ' ...
   '--word-ins-penalty=0.0 ark:- ark:- |' ...
   P.KaldiRoot '/latbin/lattice-best-path --verbose=0  --word-symbol-table=' WList ' '...
   'ark:- ark,t:' TempScor];
system([c ' &> ' Log]);



%TempScor to TempETran
int2sym=[P.KaldiTrunkRoot '/egs/wsj/s5/utils/int2sym.pl'];
c=['cat ' TempScor ' | ' int2sym ' -f 2- ' ...
WList ' | sed s:\<UNK\>::g > ' TempETran];
system(c);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%True Trans
OTTran=[P.TrTransDir '/' TeK '.trn_all']; %Original True Transcriptions


%OTTran to TempTTran
c=['cat ' OTTran ' | sed ''s:<NOISE>::g'' | sed ''s:<SPOKEN_NOISE>::g'' > ' TempTTran];
system(c);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Add Sufix to True Trans

ModTran(TempETran,TempETran);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%TempETran2 to Wer
c=[P.KaldiRoot '/bin/compute-wer --text --mode=present ark:' TempETran ' ark:' TempTTran ' ' ...
'ark,p:- >& ' Wer]; 
system([c '; cat ' Wer]);


%
delete(TempScor,TempTTran,TempETran);




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function ModTran(DicO,DicI)
%

[Key,Val]=ReDictF(DicI);

l=length(Key);
for i=1:l    
    C = strsplit(Key{i},'_');    
    Key2{i}=[C{1} '_' C{2} '_' C{3}];
end


WrDictF(DicO,Key2,Val);





