function [BN,OrtT]=FEAsruVad(ys, do, bn, P, BN, OrtT)
%FE for DIRHA (Spatio Temporal Localization, BeamForming and Compensation)


%
P.FS        = P.FSamp*P.FSSec; 
P.PhL       = round(P.PhLSec/P.FSSec); 
P.IsoDilSa  = 0.8*P.FSamp; %Isol Dilation in Samples n is between 6400samples (400ms, 40frames) and 12800samples (800ms, 80frames) before the start of the signal
P.IsoDilFr  = round(P.IsoDilSa/P.FS);
 




%Estimate Vad
[vad]=ReSidEmbVad(P.dy,bn,P.FEOpt1); 
nf=length(vad);


%Oracle Info
Isol=Info2OrTSLoc(ys,ys,vad,P.FS,P.Info,P.IsoDilSa);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% %XUadNoTr=FindXUadNoTr(XUad,ys,bn,P);
% 
% 
% [Isol2]=HUad2Isol(Uad,Isol,ys,ys,bn,nf,'Cst',P);
% 
% Uad2=HIsol2Uad(Isol2,nf,P); %Transcribed XUad
% 
% 
% subplot(311), jplot(Uad)
% subplot(312), jplot(Uad2)
% subplot(313), jplot(UadInfo)
% pause

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%
[BN,OrtT]=FEEnhIsol(Isol,do,P,BN,OrtT);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [BN,OrtT]=FEEnhIsol(Isol,do,P,BN,OrtT)
%FE Enhancement of Isolates
l=length(StArFNExtract(Isol,'ym'));
l2=length(BN);

NRU=P.FEOpt4;
l=min(NRU,l);

for i=1:l  
%for i=28:l   
    P.Temp.WTrans=Isol(i).WTrans;
    P.Temp.vad=Isol(i).vad;        
    
    [pn,bn]=fileparts(Isol(i).bn);       
    fprintf('FEUnc %d/%d: %s\n',i,l,bn);    
    [BN{l2+i},OrtT{l2+i}]=FEUnc(Isol(i).ym,do,bn,P);
end




function XUadNoTr=FindXUadNoTr(XUad,ys,bn,P)
%
%XUadTr
nf=length(XUad);
[XIsolTr]=HUad2Isol(XUad,P.Info,ys,ys,bn,nf,'Cst',P);
XUadTr=HIsol2Uad(XIsolTr,nf,P); %Transcribed XUad

%XUadNoTr
XUadNoTr=XUad; %No transcribed XUad
XUadNoTr(XUadTr>0)=0;

