function [Fbnest,vad,nsest]=EmbVad2IsoNoise(VadEmbo,Fby,Fbyemb,ysemb,P)
%
ClK=P.PhL; %around 25 frames
HSmL=2; %Half Smooth time Length for noise estimation


%Compute start of isolate
s=size(Fbyemb,2)-size(Fby,2); 

%Put some zeros in case VAD all 1
[VadEmb, VadEmbNSig]=CheckVad(VadEmbo,s,P.ContFr);
%VadEmb=VadEmbo; VadEmbNSig=VadEmbo;


%Noise from VadEmb
[FbnestNoSmEmb,Mask]=VadNoise(Fbyemb,VadEmb,ClK);  
FbnestEmb=MeanF(FbnestNoSmEmb,HSmL); 
[Fbnest,vad]=Emb2IsoN(FbnestEmb,VadEmb,s);      

%Link Noise Signals using VadEmbNSig
nsest=VadSign(ysemb,not(VadEmbNSig),P.FS);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [Fbn,vad]=Emb2IsoN(Fbnemb,VadEmb,s)
%Remove the beggining context of Fbnemb to obtain Fbn 
Fbn=Fbnemb(:,s+1:end);
vad=VadEmb(s+1:end);


function [VadEmb,VadEmbNSig]=CheckVad(VadEmbo,s,ContFr)
%Signal Noise Vad

VadEmb=VadEmbo;
%If all 1 put 0 around s
if sum(not(VadEmb))==0;  VadEmb(s-2:s+2)=0; end

%If during isolated we have more than context
VadEmbNSig=VadEmb;
a=s-2*ContFr;
VadEmbNSig(1:a)=1;
if sum(not(VadEmbNSig(a:end)))<ContFr
    fprintf('WARNING in Chi3VadN: Poor number of silences around Isolated to estimate noise\n');
end
    
% subplot(311), jplot(VadEmbo)
% subplot(312), jplot(VadEmb)
% subplot(313), jplot(VadEmbNSig)
% pause


