function [xe]=SignEnh(y,n,Fs,k,P,bn)
%Signal Enhancement

    
[ns,nch]=size(y);
if nch==7
    RefMic=P.RefMic;
else
    fprintf('WARNING: NCh ~= 7 so RefMic=end\n');
    RefMic=nch;
end



fprintf('SignEnh with %s...\n',k);



switch k
    
       %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%       
        
    case 'Chi3TrueN' %Enhance          
        xe=Chime3Enh(y(:,2:end),Fs,n(:,2:end));       
        
   
    case 'Chi3Or' %Original Chime3        
        fn=EnhFiNa(P.EnhRoot,P.SpCond2,bn,'.wav');       
        xe=audioread(fn);       
        
    case  'Chi3' %Enhance          
        [ncov,Fs]=ReChi3Emb(P.Info,12800,y);       
        xe=Chi3Enh(y(:,2:end),Fs,ncov(:,2:end));          
    
    case  'Chi3NCov' %Enhance            
        xe=Chi3Enh(y(:,2:end),Fs,P.ncov(:,2:end));        
        
    case 'Chi4Arie'      
        fn=EnhFiNa([P.SpeechRoot '/CHIME4_All/avg'],P.SpCond2,bn,'.S.20a.wav');
        xe=audioread(fn);   
        
    case 'Chi3DS' %     
        xe=Chime3Enh_DS(y(:,2:end),Fs);        


        
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    
    case 'RefMic' %Ref Channel       
        xe=y(:,RefMic); 
        
    case 'Cl' %Oracle clean
        if isnan(n)
            warning('Used Aries');    
            fn=EnhFiNa([P.SpeechRoot '/CHIME4_All/avg'],P.SpCond2,bn,'.S.20a.wav');
            xe=audioread(fn);   
        else
     
            xe=y-n; %ma=max(abs(xe(:))); xe=xe/ma; %why this? after y,x and n not OK
            xe=xe(:,RefMic); 
        end
        
    case 'ClT' %Close Talk Mic
        xe=y(:,1);
        
        
        
    case 'ClChi3' %Obtain oracle clean and later clean enhancement
        x=y-n;  n=zeros(size(x));          
        xe=Chime3Enh(x(:,2:end),Fs,n(:,2:end));
 
     
    case 'PabloNmf'
        n=n(:,RefMic);   y=y(:,RefMic);       
        x=y-n;     [xe,ne]=use_nmfshpn(y);        
 
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function fn=EnhFiNa(EnhRoot,SpCond2,bn,ext)
%

 C=strsplit(SpCond2,'_');
        if length(C)==4 %For split data base
            fn=[EnhRoot '/' C{1} '_' C{2} '_' C{3} '/' bn ext];
        else %for normal
            fn=[EnhRoot '/' SpCond2 '/'  bn ext];
        end

%         x=y-n;
%         subplot(311), plot(y)
%         subplot(312), plot(xe)
%         subplot(313), plot(x)
%         pause



