function [y]=Chi3EnhDS(x,fs)
%Delay and Sum Chime3 Enh
%x: noisy signal (opposite to Juan notation)
%y: enhanced

fprintf('Chime3Ehn_DS....\n');

% Define hyper-parameters
pow_thresh=-20; % threshold in dB below which a microphone is considered to fail
wlen = 1024; % STFT window length

%
[nsampl,nchan]=size(x);
  
% Check microphone failure
xpow=sum(x.^2,1);
xpow=10*log10(xpow/max(xpow));
fail=(xpow<=pow_thresh);

% STFT
X = stft_multi(x.',wlen);
[nbin,nfram,~] = size(X);


% Localize and track the speaker
fprintf('Localize and track the speaker\n');
[~,TDOA]=localize(X);

% MVDR beamforming
fprintf('DS beamforming\n');
Y=zeros(nbin,nfram);
for f=1:nbin    
    for t=1:nfram,
        Xtf=permute(X(f,t,:),[3 1 2]);
        Df=sqrt(1/nchan)*exp(-2*1i*pi*(f-1)/wlen*fs*TDOA(:,t)); % steering vector
        %Y(f,t)=Df(~fail)'/(Ncov(~fail,~fail,f)+regul*diag(Xspec(~fail,f)))*Xtf(~fail)/(Df(~fail)'/(Ncov(~fail,~fail,f)+regul*diag(Xspec(~fail,f)))*Df(~fail));
        Y(f,t)=Df(~fail)'*Xtf(~fail);        
    end
end
y=istft_multi(Y,nsampl).';

% Write WAV file
y=y/max(abs(y));