function [y]=Chime3Enh(x,fs,n)
%
%y: enhanced
%x: noisy signal
%fs: frequency of sampling (e.g. 16000)
%n: Load context (up to 5 s immediately preceding the utterance) (different length than x)
%n is between 6400samples (400ms, 40frames) and 12800samples (800ms, 80frames) before the start of the signal
%(S.noise_start for Chime3 or S.s for Juan)




fprintf('Chime3Ehn....\n');

% Define hyper-parameters
pow_thresh=-20; % threshold in dB below which a microphone is considered to fail
wlen = 1024; % STFT window length
regul=1e-3; % MVDR regularization factor

%
[nsampl,nchan]=size(x);
  
% Check microphone failure
xpow=sum(x.^2,1);
xpow=10*log10(xpow/max(xpow));
fail=(xpow<=pow_thresh);


% STFT
X = stft_multi(x.',wlen);
[nbin,nfram,~] = size(X);

% Compute noise covariance matrix
fprintf('Compute noise covariance matrix\n');

if size(n,1)<7
    fprintf('WARNING in Chime3Enh: noise n very small\n');
    n=zeros(7,6);
end


N=stft_multi(n.',wlen);
Ncov=zeros(nchan,nchan,nbin);
for f=1:nbin,
    for t=1:size(N,2),
        Ntf=permute(N(f,t,:),[3 1 2]);
        Ncov(:,:,f)=Ncov(:,:,f)+Ntf*Ntf';
    end
    Ncov(:,:,f)=Ncov(:,:,f)/size(N,2);
end

% Localize and track the speaker
fprintf('Localize and track the speaker\n');
[~,TDOA]=localize(X);

% MVDR beamforming
fprintf('MVDR beamforming\n');
Xspec=permute(mean(abs(X).^2,2),[3 1 2]);
Y=zeros(nbin,nfram);


for f=1:nbin    
    for t=1:nfram,
        Xtf=permute(X(f,t,:),[3 1 2]);
        Df=sqrt(1/nchan)*exp(-2*1i*pi*(f-1)/wlen*fs*TDOA(:,t)); % steering vector
        Y(f,t)=Df(~fail)'/(Ncov(~fail,~fail,f)+regul*diag(Xspec(~fail,f)))*Xtf(~fail)/(Df(~fail)'/(Ncov(~fail,~fail,f)+regul*diag(Xspec(~fail,f)))*Df(~fail));
        %Y(f,t)=Df(~fail)'*Xtf(~fail); for DS
    end
end
y=istft_multi(Y,nsampl).';

% To Write WAV file
y=y/max(abs(y));

            

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%





