function [FBN,Trans,a]=FEEmbBase(y, x, do, bn, P)
%FE for DIRHA (Spatio Temporal Localization, BeamForming and Compensation)

%Parameters
P.DilVadLFr = 0; %Dilation Vad Length in Frames
P.FL        = P.FSamp*P.FLSec; 
P.FS        = P.FSamp*P.FSSec; 
P.SpStyK    = P.FEOpt1; %Speech Style Kind (to select recognition sentences)

%
Isol=Info2OrTSLoc(y, x, do, bn, P.Info, P); %VAD Segmentation (true, using P.Info)
Isol=BNSelIsol(Isol,P.SpStyK); %Utterance selection (all, read, spontaneous commands) 
Isol=FEIsol(Isol,do,P); a=-1; %Feature Extraction
%Recognition
if ~P.HmmTr 
    [Isol,FBN,Trans]=RecogIsol(Isol,do,bn,P); %Recognize
else
    a=-1; FBN{1}='sim'; Trans{1}='xx'; %Not recognize (for HMM training)
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function Isol=FEIsol(Isol,do,P)
%FE of Isolates
l=length(StArFNExtract(Isol,'y'));
for i=1:l       
    Isol(i).Feat=FEBase(Isol(i).y,Isol(i).y,do,Isol(i).bn,P); %Enhacement
end


function [Isol,FBN,Trans]=RecogIsol(Isol,do,bn,P)
%Recognition of Isol
l=length(StArFNExtract(Isol,'y'));
for i=1:l    
     Isol(i).EstWTrans=Recog(Isol(i).Feat,'-1',do,Isol(i).bn,P);  
     %Isol(i).EstWTrans='xx xx';
     
end
[FBN,Trans]=SortCatStTrans(Isol,do,bn,'s');


