function [Feat]=FEBase(ys, xs, do, bn, P)
%Feature Extractor for Baseline
% y, x: noisy and clean mono, stereo or microphone array signals
% do:   utput dir
% P:    Parameters structure

%Parameters
P.FL=P.FSamp*P.FLSec; 
P.FS=P.FSamp*P.FSSec; 
P.N2pi=2^ceil(log2(P.FL*2));
P.win=hamming(P.FL); 

%FE
S=SegPrepr(P,ys,xs);
S=YXN(S,bn,do,P);
%
Feat.CxestD=S.CxestD;
Feat.Fby=S.Fby;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function S=SegPrepr(P,ys,xs)
%Segmentations

if size(ys,2)>1
    %S.y=ys(:,P.RefChan);      
    [S.y,MicO]=All2MicSign(ys,P.AMicN,{'LA6'});    
else
    S.y=ys;
end

% S.y=OffPreEmph(S.y);
[S.My nf]=Segmx(S.y,P.FL,P.FS);
S.nf=nf;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function S=YXN(S,bn,do,P)
%Spectrum 
S.Y=Msd(S.My,'x',P.N2pi,P);
S.Fby=SmoothFreqCompr(S.Y,P.NCH,P.FSamp,P.N2pi,P.MF);
S.Cy=Fbank2Cepst(S.Fby,-1,P.CepL,0,1,0);
S.CxestD=AppDeltas(S.Cy,2,2,'feat');

WriteHTKF([do '/' bn '.Cxest'], S.CxestD, 0, 1);

% wavwrite(S.y,P.FSamp,[do '/' bn '.wav']);  fprintf('Writted %s\n',[do '/' bn '.wav']);
% soundsc(S.y,P.FSamp)
% imagesc(S.Fby)
% pause


    
    
    
