function Chi3Ph2SVU
%

%Input
IPhF='/home/jmorales/SpeechData/CHIME3_All/LM/lang_test_tgpr_5k/phones.txt';

%Output
OPhF='/home/jmorales/SpeechData/CHIME3_All/LM/lang_test_tgpr_5k/Ph2SVUDic.txt';


%
[Key,Val]=ReDictF(IPhF);
l=length(Key);
for i=1:l    
    a=Key(i);     
    a=a{:};
    C=strsplit(a,'_');    %remove _B (begining) _I ()       
    Val{i}=Ph2SVU(C{1});    
end

%
WrDictF(OPhF,Key,Val);




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function O=Ph2SVU(Ph)
%
%Ph: Ph

switch Ph
    case {'AA' 'AA0' 'AA1' 'AA2' 'AE' 'AE0' 'AE1' 'AE2' 'AH' 'AH0' 'AH1' 'AH2' 'AO' 'AO0' 'AO1' 'AO2' 'AW' 'AW0' 'AW1' 'AW2' 'AY' 'AY0' 'AY1' 'AY2' ...
          'EH' 'EH0' 'EH1' 'EH2' 'ER' 'ER0' 'ER1' 'ER2' 'EY' 'EY0' 'EY1' 'EY2' ...
          'IH' 'IH0' 'IH1' 'IH2' 'IY' 'IY0' 'IY1' 'IY2' ...
          'OW' 'OW0' 'OW1' 'OW2' 'OY' 'OY0' 'OY1' 'OY2' ...
          'UH' 'UH0' 'UH1' 'UH2' 'UW' 'UW0' 'UW1' 'UW2'}
        O='V';
        
        
    case {'B' 'CH' 'D' 'DH' ...
           'F' 'G' 'HH' ...
           'JH' 'K' 'L' 'M' 'N' 'NG' ...
           'P' 'R' 'S' 'SH' ...
           'T' 'TH' ...
           'V' 'W' 'Y' 'Z' 'ZH'}
       
        O='U';
        
        
    case {'SIL' 'SPN', 'NSN'}
        O='S';
        
    case {'#0' '#1' '#10' '#11' '#12' '#13' '#14' '#2' '#3' '#4' '#5' '#6' '#7' '#8' '#9' '<eps>'}
        O='NUMB';
        
    otherwise
        warning('No ph conversion')
end








