function WrAllJobJSonCamp(AllJob,JobS)
%Wr All Jobs in Sh script

AS=Sub2Camp(JobS{1},'All');

S.name='JuanCampaign';

S.clusters.nancy=[];
S.clusters.rennes=[];

S.walltime=AS.walltime;
S.resources=AS.resources;
%S.nb_jobs='1'; %nicht noetig wann params
S.exec_file=AS.exec_file;


l=length(JobS);
S.params=cell(l,1);
for i=1:l  
    S.params{i}=Sub2Camp(JobS{i},'Param');         
end


mat2json(S,AllJob);

fprintf('Written: %s\n',AllJob);
fprintf('Execute as: gridsub -f AllJob.jdl\n');


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function O=Sub2Camp(s,kind)
%
% { "name": "JuanName",   
%     "resources": "core=1",  "walltime": "00:30:00",   
%     "exec_file": "/home/jmoralescordovilla/cigri/P/ExeMatPr.sh", "nb_jobs": 1,   "clusters": {"nancy": {}, "rennes":{}}}
% After -S is the command

exec_file=FindB2Str(s,' -S "',' ');
params=FindB2Str(s,[exec_file ' '],'"');
if strcmp(kind,'All')
    O.params=params;
    O.exec_file=exec_file;
    k=strfind(s,'; oarsub'); O.prologue=s(1:k);
    O.walltime=FindB2Str(s,'walltime=',' ');
    O.resources=FindB2Str(s,' -l ',',');
    O.stdoe=FindB2Str(s,'--stdout=',' --stderr');
else
    O=params;
end






